#ifndef IFXMIPS_PTM_FW_DANUBE_H
#define IFXMIPS_PTM_FW_DANUBE_H


/******************************************************************************
**
** FILE NAME    : ifxmips_ptm_fw_danube.h
** PROJECT      : Danube
** MODULES     	: PTM (ADSL)
**
** DATE         : 1 AUG 2005
** AUTHOR       : Xu Liang
** DESCRIPTION  : PTM Driver (PP32 Firmware)
** COPYRIGHT    : 	Copyright (c) 2006
**			Infineon Technologies AG
**			Am Campeon 1-12, 85579 Neubiberg, Germany
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.
**
** HISTORY
** $Date        $Author         $Comment
**  4 AUG 2005  Xu Liang        Initiate Version
** 23 OCT 2006  Xu Liang        Add GPL header.
*******************************************************************************/


#define PTM_FW_VER_MAJOR        0
#define PTM_FW_VER_MINOR        17


static unsigned int firmware_binary_code[] = {
    0x800004a0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8000ffc8, 0x00000000, 0x00000000, 0x00000000,
    0xc1000002, 0xd90c0000, 0xc2000002, 0xda080001, 0x80005618, 0xc2000000, 0xda080001, 0x800055b8,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x94000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x80005da8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x94000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x94000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x94000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x94000001, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xc10e0002, 0xd90c0000, 0xc0004808, 0xc8400000, 0x80005288, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xc3e1fffe, 0x597dfffe, 0x593dfef4, 0x900004d9, 0x00000000, 0x00000000, 0x00000000, 0x90cc0481,
    0x00000000, 0x00000000, 0x00000000, 0xc3e02262, 0x5bfc0022, 0xc0004002, 0xcfc00000, 0xc0004810,
    0xcbc00000, 0x00000000, 0xc3800000, 0xc7f80040, 0x5fb80000, 0xc7fa0040, 0xc7bfe80a, 0x5fb80000,
    0x00000000, 0xc7bff80a, 0xdbd40001, 0xc00049a0, 0xc3800002, 0xa7ca004a, 0xc1200000, 0x5911fffe,
    0xcd000001, 0xc1200000, 0x59102042, 0xcd000001, 0xc1000004, 0xcd000001, 0xc1200000, 0x59103a1e,
    0xcd000001, 0x80000048, 0xc121fffe, 0x5911fffe, 0xcd000001, 0xc1203db8, 0x5910de82, 0xcd000001,
    0xc1000006, 0xcd000001, 0xc120385a, 0x591033da, 0xcd000001, 0x5fb80002, 0x88000002, 0x6ffe0010,
    0x8000ff10, 0xdd7c0001, 0xc3800000, 0xc7f86018, 0x5bb80008, 0xc3540002, 0x77f5a000, 0xc1000008,
    0x4539c002, 0xcf800001, 0xdb900040, 0xc3800008, 0xc3720002, 0x77f5a000, 0xa7f00008, 0x47b9c002,
    0xc1000000, 0xc7d26018, 0x4391c000, 0xcf800000, 0xdb900840, 0xc3c00000, 0xdbc80001, 0xc0400000,
    0xc11c0000, 0xc000082c, 0xcd040e08, 0xc11c0002, 0xc000082c, 0xcd040e08, 0xc0400002, 0xc11c0000,
    0xc000082c, 0xcd040e08, 0xc11c0002, 0xc000082c, 0xcd040e08, 0xc0000824, 0x00000000, 0xcbc00001,
    0xcb800001, 0xcb400001, 0xcb000000, 0xc0004878, 0x5bfc4000, 0xcfc00001, 0x5bb84000, 0xcf800001,
    0x5b744000, 0xcf400001, 0x5b304000, 0xcf000000, 0xc0000a10, 0x00000000, 0xcbc00001, 0xcb800000,
    0xc0004874, 0x5bfc4000, 0xcfc00001, 0x5bb84000, 0xcf800000, 0xc30001fe, 0xc000140a, 0xcf000000,
    0xc3000000, 0x7f018000, 0xc000042e, 0xcf000000, 0xc000040e, 0xcf000000, 0xc3c1fffe, 0xc000490e,
    0xcfc00080, 0xc000492c, 0xcfc00080, 0xc0004924, 0xcfc00040, 0xc0004912, 0xcfc00040, 0xc000498c,
    0xcfc00040, 0xc000498e, 0xcfc00080, 0xc0004990, 0xcfc00080, 0xc3c00000, 0xc2800004, 0xc3000000,
    0x7f018000, 0x6ff88000, 0x6fd44000, 0x4395c000, 0x5bb84a00, 0xc00049a0, 0xcb000000, 0x00000000,
    0x58380006, 0xcf000000, 0xc321fffe, 0x5b31fffe, 0x58380024, 0xcf000000, 0x5bfc0002, 0xb7e8ff70,
    0x00000000, 0xc3c00000, 0xc2800010, 0x6ff86000, 0x47f9c000, 0x5bb84c80, 0xc3400000, 0x58380004,
    0xcb420080, 0x00000000, 0x58380008, 0xcf400080, 0x5bfc0002, 0xb7e8ff90, 0x00000000, 0xc3c00000,
    0xc2800004, 0xc3400022, 0xc3000000, 0x7f018000, 0xc2c00016, 0x6ff8a000, 0x47f9c000, 0x5bb84e20,
    0x58380008, 0xcf400040, 0xc00049a8, 0xcb000000, 0x00000000, 0x5838000a, 0xcf000000, 0xc321fffe,
    0x5b31fffe, 0x5838000c, 0xcf000000, 0x58380034, 0xcec00040, 0x5bfc0002, 0xb7e8ff58, 0x00000000,
    0x00000000, 0xc0004840, 0xc3e12624, 0x5bfc2320, 0xcfc00001, 0xc3e02f2c, 0x5bfd2a28, 0xcfc00001,
    0xc3e03734, 0x5bfd3230, 0xcfc00001, 0xc3e13e3c, 0x5bfc3b38, 0xcfc00001, 0xc3e14644, 0x5bfc4340,
    0xcfc00001, 0xc3e04f4c, 0x5bfd4a48, 0xcfc00001, 0xc3e05754, 0x5bfd5250, 0xcfc00001, 0xc3e15e5c,
    0x5bfc5b58, 0xcfc00001, 0xc3e06764, 0x5bfd6260, 0xcfc00001, 0xc3e16e6c, 0x5bfc6b68, 0xcfc00001,
    0xc3e17674, 0x5bfc7370, 0xcfc00001, 0xc3e07f7c, 0x5bfd7a78, 0xcfc00001, 0xc3e18684, 0x5bfc8380,
    0xcfc00001, 0xc3e08f8c, 0x5bfd8a88, 0xcfc00001, 0xc3e09794, 0x5bfd9290, 0xcfc00001, 0xc3e19e9c,
    0x5bfc9b98, 0xcfc00001, 0xc121fffe, 0x5911fef4, 0x15000000, 0x80000010, 0x00000000, 0x80000638,
    0x00000000, 0x8000ffc8, 0xc0004918, 0xd2800000, 0xc2000000, 0xdf600040, 0x5e600080, 0x8400029a,
    0x00000000, 0xc161fffe, 0x5955fffe, 0x15400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0xc000480a, 0xca000000, 0xc0004912, 0xca400000, 0xc0004924, 0xca800000,
    0xc000498c, 0xcac00000, 0xc121fffe, 0x5911fef4, 0x15000000, 0x76610000, 0x76a10000, 0x76e10000,
    0x840001d2, 0xc0004918, 0xca400000, 0xc28001fe, 0x76a10000, 0x5a640002, 0x6a254010, 0x5ee80000,
    0x84000002, 0x6aa54000, 0x8000fff8, 0xc6280000, 0x62818008, 0xc0004918, 0xcf000000, 0xc161fffe,
    0x5955fffe, 0x15400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xc000498c, 0xca400000, 0xc2000002, 0x6a310000, 0x7e010000, 0x76252000, 0xce400000, 0xc121fffe,
    0x5911fef4, 0x15000000, 0x6f346000, 0x4735a000, 0x5b744c80, 0xc2800000, 0x58340006, 0xca800080,
    0xc2c00000, 0x58340000, 0xcac000e0, 0xc2400000, 0x5834000a, 0xca420080, 0x6ea82000, 0x42e9e000,
    0x6f2ca000, 0x42e56000, 0x5aec1400, 0xc3990040, 0xc7381c20, 0xc6f80068, 0x99006840, 0xdb980000,
    0xdbd80001, 0x00000000, 0xdea00000, 0x47210000, 0x8400fd28, 0xc000495a, 0xc8400000, 0x00000000,
    0xc3c00002, 0x7bc42000, 0xcc400000, 0xc0000838, 0xc3800000, 0xcb840030, 0x6c748000, 0x6c544000,
    0x4355a000, 0x5b744a00, 0x5ef80000, 0x8400fc8a, 0x58340004, 0xcb000000, 0x00000000, 0x00000000,
    0xa7060000, 0x00000000, 0x5ef80002, 0x8400fc4a, 0x5834000c, 0xc8800040, 0xc2000000, 0xc000082c,
    0xca040030, 0x5a880002, 0xc2400000, 0xc0004958, 0xce400000, 0xb628fff8, 0x00000000, 0xc2800000,
    0x58340002, 0xc2000000, 0xca020010, 0xc0004956, 0xce800000, 0x5e600000, 0x84001df2, 0x5e600002,
    0x840043da, 0x00000000, 0x80002320, 0xc0004958, 0xca000000, 0xc0004956, 0xca800000, 0x5e200000,
    0x84000008, 0xc2500002, 0xc0000838, 0xce440808, 0x6c748000, 0x6c544000, 0x4355a000, 0x5b744a00,
    0x5834000c, 0xc6900040, 0xcd000040, 0x58340002, 0xc2000000, 0xca020010, 0x00000000, 0x00000000,
    0x5f600000, 0x84000122, 0xc0004818, 0xc8000000, 0x00000000, 0x00000000, 0x5c000000, 0x840000f2,
    0xc11c0000, 0xc000082c, 0xcd040e08, 0xc0000838, 0xc3800000, 0xc2400000, 0xcb840030, 0xca452030,
    0x00000000, 0x42b9a000, 0x5e340022, 0x88000012, 0xc200001e, 0x7635a000, 0x5f740002, 0x8000fff0,
    0x6e642010, 0x4675a000, 0x84000042, 0xc0004818, 0xc8000000, 0x00000000, 0x00000000, 0x5c000000,
    0x84000012, 0x00000000, 0x00000000, 0x00000000, 0x8000ffa0, 0xc11c0002, 0xc000082c, 0xcd040e08,
    0x8000f9b8, 0xc2000000, 0xdf600040, 0x5e200080, 0x84000272, 0x00000000, 0xc161fffe, 0x5955fffe,
    0x15400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc000480c,
    0xca000000, 0xc0004910, 0xca400000, 0xc000492c, 0xca800000, 0xc000498e, 0xcac00000, 0xc121fffe,
    0x5911fef4, 0x15000000, 0x76610000, 0x76a10000, 0x762d6000, 0x840001aa, 0xc0004926, 0xca400000,
    0xc201fffe, 0x762d6000, 0x5a640002, 0x6ae50010, 0x5f200000, 0x84000002, 0x6a250000, 0x8000fff8,
    0xc6e00000, 0x62014008, 0xc0004926, 0xce800000, 0xc161fffe, 0x5955fffe, 0x15400000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc000498e, 0xca400000, 0xc2000002,
    0x6a290000, 0x7e010000, 0x76252000, 0xce400000, 0xc121fffe, 0x5911fef4, 0x15000000, 0x6eb4a000,
    0x46b5a000, 0x5b744e20, 0x58340002, 0xc2000000, 0xca0000e0, 0x58340036, 0xc2400000, 0xca400080,
    0x6eb0a000, 0x46b18000, 0x5b300e56, 0x5b300004, 0x6e642000, 0x4225e000, 0xc39a8024, 0xc7380068,
    0xc6b81c20, 0x99006840, 0xdb980000, 0xdbd80001, 0x00000000, 0xc2000000, 0xdf600040, 0x5e200080,
    0x840002c2, 0x00000000, 0xc161fffe, 0x5955fffe, 0x15400000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0xc000490e, 0xca000000, 0xc000492a, 0xca400000, 0xc0004990,
    0xcb000000, 0xc000498a, 0xcac00000, 0xc121fffe, 0x5911fef4, 0x15000000, 0x76318000, 0x76718000,
    0x84000202, 0xc201fffe, 0x76318000, 0x5aec0002, 0x6b2d0010, 0x5ea00000, 0x84000002, 0x6a2d0000,
    0x8000fff8, 0xc7200000, 0x62016008, 0xc000498a, 0xcec00000, 0xc161fffe, 0x5955fffe, 0x15400000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0004990, 0xca400000,
    0xc2000002, 0x6a2d0000, 0x7e010000, 0x76252000, 0xce400000, 0xc121fffe, 0x5911fef4, 0x15000000,
    0x6ef4a000, 0x46f5a000, 0x5b744e20, 0x58340010, 0xc2000000, 0xca0000e0, 0x58340008, 0xc2400000,
    0xca420080, 0x5834000e, 0xc2800000, 0xca832018, 0xc3c00000, 0x467c8000, 0x6e644010, 0xc7e80004,
    0x42250000, 0x4229e000, 0xc39a8008, 0x58340008, 0xcb801040, 0x58340008, 0xc2800000, 0xca810018,
    0x6ee0a000, 0x46e10000, 0x5a20000a, 0x5a200e28, 0x42290000, 0xc6380068, 0xc6f81c20, 0x99006840,
    0xdb980000, 0xdbd80001, 0x00000000, 0xc000495c, 0xc8400000, 0xc3400000, 0xc3c00002, 0x7bc42000,
    0xcc400000, 0x6c78a000, 0x4479c000, 0x5bb84e20, 0x58380034, 0xcb410040, 0xc0000a28, 0xc3000000,
    0xcb040030, 0xc0000a14, 0xc2c00000, 0x43358000, 0xcac40030, 0xc000490e, 0xca800000, 0x5eec0002,
    0x46f18000, 0x8800f348, 0x6bc5e000, 0x77e94000, 0x8400f330, 0x6c7ca000, 0x447de000, 0x5bfc4e20,
    0x583c0008, 0xc2000000, 0xca020080, 0xc00049aa, 0x00000000, 0xca800001, 0xca400000, 0xc0001008,
    0xce800000, 0xc0001006, 0xce400000, 0x583c000a, 0xca400000, 0x00000000, 0xc000100a, 0xce400000,
    0xc2400006, 0xc0001000, 0xce400000, 0xc2600982, 0x5a643b6e, 0xc0001002, 0xce400000, 0x583c000c,
    0xca400000, 0x00000000, 0xc0001004, 0xce400000, 0x583c000e, 0xcb800000, 0x00000000, 0xc2400000,
    0xc7a40080, 0xc2800000, 0xc7aae028, 0xdaa00001, 0x583c0034, 0xcb800000, 0x00000000, 0xc2c00000,
    0xc7ad0040, 0xc0004978, 0xcec00000, 0xc0800000, 0xc7880040, 0xc3400000, 0xc7b60040, 0xc0004980,
    0xcf400000, 0x4625c000, 0x43a9c000, 0xc2400000, 0xc000497c, 0xce400000, 0xac2c0001, 0xc2800000,
    0x00000000, 0x8000fff8, 0xc2800002, 0xc0004976, 0xce800000, 0xc2c00000, 0xc34000a0, 0xdb5c0001,
    0xc3400002, 0xc000497a, 0xcf400000, 0x5f600000, 0x84000168, 0xde280001, 0xc6a00000, 0x46b9c000,
    0x583c0000, 0xc2800000, 0xca830040, 0xc0000a28, 0xc3000000, 0xcb040030, 0xc3400000, 0xc0004976,
    0x47298000, 0x88000052, 0xcf400000, 0x58880002, 0xc3000000, 0xc0000a14, 0xcb040030, 0x00000000,
    0x00000000, 0xb4b00188, 0x00000000, 0xc0800000, 0x00000000, 0x80000170, 0xc0004980, 0xcb400000,
    0x00000000, 0x00000000, 0x5af40002, 0xafec0080, 0x00000000, 0xc2c00000, 0xc000497a, 0xacec0001,
    0x00000000, 0x00000000, 0xac2c007f, 0xc2800000, 0xce800000, 0x80000000, 0xc2800002, 0xce800000,
    0x5f6c0000, 0x840000d0, 0x00000000, 0x8000fee8, 0x5f780082, 0x88000240, 0xc3000002, 0xc000497c,
    0xcf000000, 0xc2800080, 0xc1000000, 0xdd110040, 0x45294000, 0x46b94000, 0x880001c0, 0x4391a000,
    0xc0004980, 0xcf400000, 0x6f684010, 0x6f77c000, 0x6f77c010, 0xc0004840, 0x40280000, 0xca800000,
    0xc3000000, 0x6f506000, 0x6a908010, 0xc5300040, 0xdb1c0001, 0x8000fe18, 0xc3400000, 0xc0000a10,
    0xcb440068, 0x6cb04000, 0x6f288000, 0x6f744000, 0x42b14000, 0x43694000, 0xc3400000, 0xc6b44068,
    0xc0004000, 0x40340000, 0xc321e000, 0xcf000000, 0x5aa80008, 0x42ad4000, 0xc3400000, 0xc6b44068,
    0xc0004000, 0x40340000, 0xca400000, 0xc3000000, 0xc6f00010, 0xc1400000, 0xddd40041, 0x6f306000,
    0xc13001fe, 0x69308010, 0x7d008000, 0x75252000, 0x6d570000, 0x6970a010, 0x42552000, 0xce400000,
    0x5aa80002, 0x5aec0002, 0xafec0080, 0x00000000, 0xc2c00000, 0x5f6c0000, 0x84000100, 0x00000000,
    0x80000028, 0x4391a000, 0x5f740080, 0xc0004980, 0xcf400000, 0xc3000004, 0xc000497a, 0xcf000000,
    0x58880002, 0xc3400000, 0xc0000a14, 0xcb440030, 0x00000000, 0x00000000, 0xb4b4fff8, 0x00000000,
    0xc0800000, 0xc3400000, 0xc0000a10, 0xcb440068, 0x6cb04000, 0x6f248000, 0x6f744000, 0x42712000,
    0x43654000, 0xc3400000, 0xc6b44068, 0xc0004000, 0x40340000, 0xc3201e00, 0xcf000000, 0x5aa80008,
    0x42ad4000, 0xc000100c, 0xcb400000, 0xc3000000, 0x00000000, 0xc7340068, 0xc300fffe, 0xc7341078,
    0xcf400000, 0xc000100e, 0xcb400000, 0xc3000e28, 0x00000000, 0xc7340068, 0xc300fffe, 0xc7341078,
    0xcf400000, 0xc0001010, 0xcb400000, 0xc3000002, 0x00000000, 0xc7341a08, 0xc7341808, 0xc3000000,
    0xc7341908, 0xc6b40078, 0xcf400000, 0xc0004982, 0xce800000, 0x6c64a000, 0x44652000, 0x5a64000a,
    0xc0001012, 0xcb400000, 0xc2800002, 0x00000000, 0xc6740268, 0xc6340010, 0xc000497c, 0xcb000000,
    0xc6b41808, 0xc6b41b08, 0xc6b41c08, 0xc6b41d08, 0xc7341e08, 0xdd680001, 0x7e814000, 0x6eab2010,
    0x77294000, 0xc6b41f08, 0xc2800000, 0xc6b41908, 0xc3000080, 0x46f18000, 0xc0004982, 0xc9000000,
    0x47b14000, 0x880000ea, 0x41388000, 0xcd000000, 0xc7b41040, 0xc0004994, 0xce800000, 0xde100001,
    0x46108000, 0x84000098, 0xc1000000, 0xdd110040, 0x41388000, 0x412c8000, 0x5d100080, 0xc0004980,
    0xcd000000, 0xc1000002, 0xc000497c, 0xcd000000, 0xc5341e08, 0xdd500001, 0x7d008000, 0xc5373f08,
    0xc000497a, 0xc9000000, 0x42390000, 0x43adc000, 0x59100002, 0xcd000000, 0x80000038, 0x42390000,
    0x80000028, 0xc7341040, 0x41308000, 0xcd000000, 0x42310000, 0xc1000000, 0xc0004994, 0xcd000000,
    0xc0001012, 0xcf400000, 0xc000493c, 0xce000000, 0xc0004984, 0xcf800000, 0xc000497a, 0xca400000,
    0xc000497c, 0xca800000, 0x6c7ca000, 0x447de000, 0x5bfc4e20, 0xc0004976, 0xcac00000, 0xc0004978,
    0xca000000, 0x5eec0002, 0x84000072, 0x42250000, 0xc2400000, 0xc000497a, 0xce400000, 0x583c0000,
    0xc2c00000, 0xcac30040, 0x00000000, 0x00000000, 0x462d6000, 0x88000002, 0x00000000, 0xac280002,
    0xc000497a, 0xce000000, 0xc2000000, 0x5fa80000, 0x840001c2, 0x00000000, 0x6c508000, 0xc0004880,
    0x40100000, 0x58000018, 0xc9000000, 0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0x583c000e,
    0xc2c00000, 0xcac00080, 0xc1000000, 0xdd532209, 0x42d16000, 0x6c508000, 0xc0004880, 0x40100000,
    0x5800001a, 0xc9000000, 0x00000000, 0x00000000, 0x412c8000, 0xcd000000, 0x990068d0, 0xd8580000,
    0xdbd80001, 0x00000000, 0x99006618, 0xc000491c, 0xc1400000, 0xc9420050, 0xc000491c, 0x99006ad0,
    0xc9400001, 0xc9800000, 0x00000000, 0x99006840, 0xd9580000, 0xd9980001, 0x00000000, 0xc161fffe,
    0x5955fffe, 0x15400000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x98c06490, 0xd8580000, 0xdbd80001, 0xc4580000, 0xc121fffe, 0x5911fef4, 0x15000000, 0xace80003,
    0xc000493c, 0xcb400000, 0x00000000, 0xc3000000, 0xc7701080, 0x8000fff8, 0xc3000000, 0x583c0008,
    0xcf001080, 0x6e210000, 0x583c0034, 0xce000840, 0xc0004980, 0xcb800000, 0x583c0034, 0x00000000,
    0x6fba0000, 0xcf801040, 0xc000490e, 0xca000000, 0xc2c00002, 0x6ac56000, 0x72e10000, 0xce000000,
    0x00000000, 0x00000000, 0x00000000, 0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000, 0x5fa80000,
    0x840006fa, 0xc00049a8, 0xca000000, 0x583c000a, 0x00000000, 0xce000000, 0xc221fffe, 0x5a21fffe,
    0x583c000c, 0xce000000, 0xc0001004, 0xca000000, 0x00000000, 0x583c0012, 0x7e010000, 0xce000000,
    0xa97000c1, 0x00000000, 0x00000000, 0xa97200a9, 0xc0001010, 0xc2740000, 0xce401a08, 0x6c64a000,
    0x44652000, 0x5a64000a, 0x6e644000, 0xc0001012, 0xce400078, 0xc2600008, 0xce401040, 0xc27e0002,
    0xce401f08, 0xc2760002, 0xce401b08, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000, 0xc1000000, 0xdd110040, 0x5d100000, 0x840003fa,
    0xc0004982, 0xca000000, 0xc0004984, 0xca400000, 0xc2800000, 0xc361fffe, 0x5b75fffe, 0xa96afffb,
    0xdfec0000, 0xc6ec1080, 0x7b6d6000, 0x6c40a000, 0x44400000, 0x58004e20, 0x58000014, 0xcec00000,
    0xa972fffb, 0x5c000002, 0xcec00000, 0xc0001010, 0xc2f40002, 0xcec01a08, 0x6c6ca000, 0x446d6000,
    0x5aec000a, 0x6eec4000, 0xc0001012, 0xcec00078, 0xc0004994, 0xc9800000, 0xc1400000, 0xdd150040,
    0xc55c0000, 0x45588000, 0x00000000, 0xc59c0004, 0x5d1c0000, 0x840000ba, 0xc0001012, 0xc5d01040,
    0xcd001040, 0xc2f60002, 0xcec01b08, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000, 0x45588000, 0x8800003a, 0xc0004994, 0xcd000000,
    0xc0004980, 0xcbc00000, 0x42150000, 0xc0004982, 0xce000000, 0x5ffc0000, 0x84000200, 0x58880002,
    0xc3800000, 0xc0000a14, 0xcb840030, 0xc3c00000, 0xc0000a10, 0xb4b8fff8, 0x00000000, 0xc0800000,
    0xcbc40068, 0x6cb84000, 0x6fac8000, 0x6ffc4000, 0x42f96000, 0x43ed0000, 0xc3400000, 0xc6344068,
    0xc0004000, 0x40340000, 0xc2a1e000, 0xce800000, 0x5a200008, 0xc0004980, 0xcbc00000, 0xc3400000,
    0xc0004840, 0x6ff84010, 0xc7f40010, 0x40380000, 0xcb800000, 0xc2800000, 0x6f506000, 0x6b908010,
    0xc52c1840, 0xc3400000, 0xc6344068, 0xc0004000, 0x40340000, 0xcec00000, 0x5a200002, 0x5ffc0000,
    0x8400007a, 0xc0001010, 0xc62c0078, 0xcec00078, 0xc0001012, 0xc7ec1040, 0xcec01040, 0xc2f60002,
    0xcec01b08, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xa8e2ffc8, 0x00000000,
    0xc1220002, 0xd90c0000, 0xc0004994, 0xc100007e, 0x47d08000, 0xcd000000, 0x423d0000, 0xc0004982,
    0xce000000, 0xc0004994, 0xca000000, 0xc0004980, 0xca400000, 0x5e200000, 0x84000142, 0xc2000000,
    0xc2800000, 0x5a640002, 0xc6684030, 0xc0004982, 0xcb000000, 0xc0004000, 0xc2c00000, 0xc72c4068,
    0x402c0000, 0x6e67c000, 0x6e67c010, 0x5ee40002, 0x84000022, 0x5ee40004, 0x84000032, 0x5ee40006,
    0x84000042, 0x00000000, 0x80000048, 0xce0000c0, 0x5aa80002, 0x5b300006, 0x80000028, 0xce000080,
    0x5aa80002, 0x5b300004, 0x80000008, 0xce000040, 0x5aa80002, 0x5b300002, 0x5ee80020, 0x8400003a,
    0xc0004000, 0xc2c00000, 0xc72c4068, 0x402c0000, 0xce000000, 0x5aa80002, 0x5b300008, 0x8000ffa0,
    0x00000000, 0x80000028, 0x583c000a, 0xd7c00000, 0xc0001004, 0xca400000, 0x00000000, 0x583c000c,
    0xce400000, 0xc000497a, 0xca400000, 0xc2800002, 0xc0000a28, 0xc6780930, 0xc6b80808, 0xcf840838,
    0x6c7ca000, 0x447de000, 0x5bfc4e20, 0x583c0034, 0xc4900040, 0xcd000040, 0x8000e400, 0x6c6c8000,
    0x6c544000, 0x42d56000, 0x5aec4a00, 0xc0000824, 0xca040000, 0x6ca48000, 0x42492000, 0xc3000000,
    0xc3400000, 0x42250000, 0x58204000, 0xca400000, 0x5a200002, 0xda240001, 0xc2800000, 0xc000495e,
    0xce800000, 0xda600000, 0xc2800000, 0xc66b0040, 0xdaa80000, 0x582c0010, 0x6f206010, 0x40200000,
    0xd8280001, 0xca000000, 0xc2400000, 0xc7240018, 0x6e644000, 0xda640000, 0x6a254010, 0xc3c00000,
    0xc6bc0020, 0xc3800000, 0xdea00000, 0x5e60001e, 0x84000012, 0x5e6001e0, 0x84000002, 0x00000000,
    0x80000068, 0xc7f80000, 0x5e7c0008, 0x84000052, 0x5bbc0002, 0x5e780008, 0x84000010, 0x5b740002,
    0xc0004960, 0xcf000000, 0x80000018, 0x5e780006, 0x8800000a, 0xc2800002, 0xc000495e, 0xce800000,
    0xde800001, 0xca800000, 0xde600000, 0xc240001e, 0x6a612000, 0x7e412000, 0x76694000, 0x6ba12000,
    0x72694000, 0xce800000, 0x5e300080, 0x840000a2, 0xc2000000, 0xc7200010, 0x5e600000, 0x84000040,
    0xde600001, 0x58204000, 0xca400000, 0x5a200002, 0xda240001, 0xc2800000, 0xc66b0040, 0xdaa80000,
    0xda600000, 0x80000020, 0xc2800000, 0x6e206000, 0xde240000, 0x6a610000, 0xc62b0040, 0xdaa80000,
    0x5b300002, 0x8000fdc8, 0xc2000000, 0x582c0020, 0xca020080, 0x00000000, 0xc2400000, 0x5a200002,
    0xc6241080, 0xce401080, 0xc000480e, 0xca800000, 0x5e740000, 0x84000148, 0x46292000, 0x8800dec8,
    0xc2400000, 0xc0000808, 0xca440018, 0x582c0010, 0xc1400000, 0xcd400001, 0xcd400001, 0xcd400001,
    0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400020, 0x582c0020, 0xce001080,
    0xc2000010, 0x5a640002, 0xb624fff8, 0x00000000, 0xc2400000, 0xc6600018, 0xc0000808, 0xce040018,
    0xc0004956, 0xca400000, 0xc11c0000, 0xc000082c, 0xcd040e08, 0xc6600930, 0xc2400000, 0xc6600030,
    0xc0000838, 0xce040000, 0xc2400002, 0xc0004958, 0xce400000, 0xc11c0002, 0xc000082c, 0xcd040e08,
    0x8000dd80, 0xc000495e, 0xca000000, 0x5e740002, 0x8400dd60, 0x5e200000, 0x8400dd50, 0xc0004960,
    0xca400000, 0xc2200004, 0x582c0002, 0xce001010, 0xc2000082, 0x46610000, 0xc6280038, 0xc0000810,
    0xce840038, 0x99006f68, 0x582c0002, 0xc9400000, 0xc1a20000, 0x5e640000, 0x8400feb8, 0x00000000,
    0x8000dcc0, 0x6c6c8000, 0x6c544000, 0x42d56000, 0x5aec4a00, 0xc000487c, 0xc8040000, 0x00000000,
    0x00000000, 0x40080000, 0xcb800000, 0xc4240000, 0x00000000, 0xa7860180, 0xc3c00000, 0xc2000000,
    0x582c000c, 0xca010040, 0x6c508000, 0xc0004880, 0x40100000, 0x58000016, 0xc9000000, 0x00000000,
    0x00000000, 0x59100002, 0xcd000000, 0x5a200002, 0x582c000c, 0xc6100840, 0xcd000840, 0x5e600002,
    0x84000008, 0xc2200004, 0x582c0002, 0xce001010, 0x5e600008, 0x84000048, 0xc2200002, 0x582c0002,
    0xce001010, 0x582c000c, 0xcfc00840, 0xc2220002, 0xc0000a14, 0xce041108, 0xc22001a2, 0xc0000a1c,
    0xce041040, 0x6c6c8000, 0x6c544000, 0x42d56000, 0x5aec4a00, 0x582c0004, 0xcb000000, 0xc3400000,
    0x00000000, 0xa7060008, 0xcf400308, 0xc3100002, 0xc0000838, 0xcf040808, 0x582c000c, 0xcf401008,
    0x8000dac0, 0x582c000c, 0xcfc00840, 0xc2000000, 0xc7a06018, 0x5e200000, 0x84001e18, 0x6c6c8000,
    0x6c544000, 0x42d56000, 0x5aec4a00, 0xc000487c, 0xc8040000, 0x00000000, 0x00000000, 0x40080000,
    0xcb800000, 0xc4240000, 0x00000000, 0xc2800000, 0xc3400000, 0xc7b5c038, 0xc0004970, 0xcf400000,
    0xc2400000, 0xc7a4e038, 0xc000496c, 0xce400000, 0xc3000000, 0xc7b00018, 0xc3c00004, 0xc000496e,
    0xcfc00000, 0x582c000c, 0xca000000, 0xc2400002, 0xc0004964, 0xce400000, 0xa6200352, 0x00000000,
    0x5e700004, 0x840000d2, 0x5e700006, 0x84000068, 0xc2000002, 0x582c0002, 0xce000008, 0xc0000a14,
    0xce841108, 0x6c508000, 0xc0004880, 0x40100000, 0x58000014, 0xc9000000, 0x00000000, 0x00000000,
    0x59100002, 0xcd000000, 0x80001c68, 0x5e70000a, 0x84000028, 0xc2000000, 0x582c0002, 0xce000008,
    0xc2220002, 0xc0000a14, 0xce041108, 0x8000ff58, 0x5e700008, 0x84000210, 0xc2200002, 0x582c000c,
    0xce001008, 0x6c508000, 0xc0004880, 0x40100000, 0x58000012, 0xc9000000, 0x00000000, 0x00000000,
    0x59100002, 0xcd000000, 0x5e340002, 0x6c508000, 0xc0004880, 0x40100000, 0x58000010, 0xc9000000,
    0x00000000, 0x00000000, 0x41208000, 0xcd000000, 0xc0000a14, 0xce841108, 0xc0004970, 0xcb400000,
    0x6c6c8000, 0x6c544000, 0x42d56000, 0x5aec4a00, 0x582c000e, 0xc4900040, 0xcd000040, 0x582c000e,
    0xc7500840, 0xcd000840, 0xc2800000, 0x582c0004, 0xce801080, 0x582c0004, 0xce800008, 0xc00049a0,
    0xca400000, 0x00000000, 0x582c0006, 0xce400000, 0xc261fffe, 0x5a65fffe, 0x582c0024, 0xce400000,
    0xc2060002, 0x582c0004, 0xce000308, 0xc2400002, 0xc0004958, 0xce400000, 0xc0004878, 0xc8040000,
    0x6c908000, 0x41088000, 0x40100000, 0x58000020, 0xc9000000, 0x582c0026, 0x00000000, 0xcd000000,
    0x800019f8, 0x00000000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000016, 0xc9000000, 0x00000000,
    0x00000000, 0x59100002, 0xcd000000, 0x8000fad8, 0x5e700000, 0x840000a8, 0xc3400082, 0xc0004970,
    0xcf400000, 0xc2400080, 0xc000496c, 0xce400000, 0xc3c00002, 0xc000496e, 0xcfc00000, 0xc2400000,
    0xc0004964, 0xce400000, 0xc0004878, 0xc8040000, 0x6c908000, 0x41088000, 0x40100000, 0x58000020,
    0xc9000000, 0x582c0026, 0x00000000, 0xcd000000, 0x80000060, 0x5e700002, 0x84000040, 0xc3400082,
    0xc0004970, 0xcf400000, 0xc3c00004, 0xc000496e, 0xcfc00000, 0xc2200000, 0x582c000c, 0xce001008,
    0x80000018, 0x5e700004, 0x8400fe68, 0xc2600002, 0x582c000c, 0xce401008, 0xc0000a14, 0xce841108,
    0xc000496c, 0xca400000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000012, 0xc9000000, 0x00000000,
    0x00000000, 0x59100002, 0xcd000000, 0xc000496e, 0xcbc00000, 0x00000000, 0x00000000, 0x47f50000,
    0x46610000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000010, 0xc9000000, 0x00000000, 0x00000000,
    0x41208000, 0xcd000000, 0x6c6c8000, 0x6c544000, 0x42d56000, 0x5aec4a00, 0x582c0004, 0xca000000,
    0x00000000, 0x00000000, 0xa60016ea, 0x00000000, 0x6c6c8000, 0x6c544000, 0x42d56000, 0x5aec4a00,
    0xc3000000, 0x582c0004, 0xcf000308, 0x582c0000, 0xcb002018, 0xc3c00000, 0x582c0004, 0xcbc20080,
    0xc000491a, 0xcf000000, 0xc000493c, 0xcfc00000, 0x582c0008, 0xcb800000, 0x582c000a, 0xca400000,
    0xc0004930, 0xcf800000, 0xc0004932, 0xce400000, 0x5ffc0000, 0x840001d8, 0x00000000, 0xa7be00e2,
    0xc2800000, 0x6f206000, 0x47210000, 0x5a204c80, 0x5820000c, 0xca800028, 0x00000000, 0x00000000,
    0x5ea80000, 0x840000fa, 0x00000000, 0xc161fffe, 0x5955fffe, 0x15400000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x99006330, 0xc000491a, 0xc9400000, 0x00000000,
    0xc121fffe, 0x5911fef4, 0x15000000, 0xc0004930, 0xcb800000, 0xc0004932, 0xca400000, 0xc4781110,
    0xc0004930, 0xcf800000, 0x582c0008, 0xcf800000, 0x582c000a, 0xce400000, 0xc7b6e110, 0x582c0004,
    0xcf400110, 0x80000078, 0x00000000, 0x6c508000, 0xc0004880, 0x40100000, 0x5800000c, 0xc9000000,
    0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0xc2000002, 0x582c0004, 0xce000008, 0xc0000838,
    0xc2500002, 0xce440808, 0x80001430, 0x6c7c8000, 0x6c544000, 0x43d5e000, 0x5bfc4a00, 0x583c0006,
    0xca000000, 0xc00049a2, 0x00000000, 0xca800001, 0xca400000, 0xc0001008, 0xce800000, 0xc0001006,
    0xce400000, 0xc000100a, 0xce000000, 0xc2400006, 0xc0001000, 0xce400000, 0xc2600982, 0x5a643b6e,
    0xc0001002, 0xce400000, 0x583c0024, 0xca400000, 0x00000000, 0xc0001004, 0xce400000, 0xc0004862,
    0xc2000000, 0xca000080, 0xc360fffe, 0xc0004862, 0xce000000, 0xc0000824, 0xcb440068, 0x00000000,
    0xc000100e, 0xcf400000, 0xc3801600, 0xc2400200, 0x6e644000, 0xc6781078, 0xc000100c, 0xcf800000,
    0xc3200a00, 0xc0001010, 0xcf001818, 0xc2e06200, 0xc0001012, 0xcec01840, 0xc2000000, 0x583c0004,
    0xca002010, 0xc2800000, 0xc0004966, 0xce000000, 0xc6240000, 0xc3000000, 0xc000496a, 0xcf000000,
    0xc0004974, 0xcf000000, 0xc000493c, 0xcb400000, 0x583c000e, 0x00000000, 0x5f740000, 0x84000168,
    0xc3400000, 0xcb410040, 0xc3000002, 0xc000496a, 0x5fb40080, 0x8400013a, 0xcf000000, 0x583c000e,
    0xc2c00000, 0xcac00040, 0xc3800080, 0x4779c000, 0xc0004974, 0xcf800000, 0xc0001012, 0x6fba0000,
    0xcf801040, 0x6fba0010, 0x43a5c000, 0x5b380006, 0x6f284010, 0xc7a40010, 0x6eec4000, 0x6ef08000,
    0x432d8000, 0x43358000, 0x5b300008, 0xc0001012, 0xc7100078, 0xcd000078, 0xc2000200, 0xc2c00000,
    0xdf6d0050, 0x46e16000, 0x46ad6000, 0x8800ffca, 0xc2000000, 0xc0004862, 0xca000268, 0x00000000,
    0x583c0004, 0xca002010, 0xc3360002, 0xc0001010, 0xce000078, 0xc0001012, 0xcf001b08, 0xc0004974,
    0xcb800000, 0x00000000, 0x00000000, 0x5fb80000, 0x8400002a, 0x00000000, 0x00000000, 0x00000000,
    0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000, 0xc000496c, 0xcac00000, 0x00000000, 0x00000000,
    0x426dc000, 0x5b380006, 0x6f304010, 0xc7a40010, 0xc0004968, 0xce400000, 0xc000496e, 0xcb400000,
    0x6ca44000, 0x6e608000, 0x42250000, 0x5a200006, 0x42350000, 0xc0001012, 0xc6100078, 0xcd000078,
    0x6eee0000, 0xcec01040, 0xc2000200, 0xc2c00000, 0xdf6d0050, 0x46e16000, 0x42b14000, 0x46ad6000,
    0x8800ffc2, 0xc000493c, 0xcb400000, 0xc0000838, 0xc3100002, 0x5f740000, 0x84000048, 0xcf040808,
    0xc0004974, 0xcb800000, 0x00000000, 0x00000000, 0x5fb80000, 0x84000052, 0xc0001012, 0xc3360002,
    0xcf001b08, 0x80000088, 0x583c0022, 0xcb400000, 0xc0004862, 0xca000000, 0x00000000, 0xc0005600,
    0x40200000, 0xcf400000, 0xc2000000, 0xc0004862, 0xca000268, 0x00000000, 0x583c0004, 0xca002010,
    0xc3360002, 0xc0001010, 0xce000078, 0xc0001012, 0xcf001b08, 0xc0004968, 0xcbc00000, 0xc0004964,
    0xca400000, 0xc7e00000, 0x00000000, 0x5e640000, 0x8400fffa, 0xc2000000, 0xc0004974, 0xca400000,
    0xc000496c, 0xca800000, 0xc000493c, 0xcb800000, 0x42698000, 0x00000000, 0x43b1a000, 0x5ef40080,
    0x88000182, 0xc0004966, 0xcac00000, 0x6c648000, 0x6c544000, 0x42552000, 0x5a644a00, 0x58240000,
    0x436da000, 0x4635a000, 0xc2400000, 0xca420080, 0x00000000, 0x00000000, 0x47652000, 0x8800010a,
    0x432d8000, 0x46318000, 0x8800fff8, 0xc3000000, 0x5b300006, 0x6f304010, 0xc000493a, 0xcf000000,
    0xc0004932, 0xc2400000, 0xca4000e0, 0x00000000, 0x6fb84010, 0x42792000, 0xc000491e, 0xce400000,
    0xc0004862, 0xca800000, 0x00000000, 0xc2c0000a, 0xc6e80d78, 0xc7281050, 0xc000491c, 0xce800000,
    0x6c708000, 0x6c544000, 0x43158000, 0x5b304a00, 0x6f760000, 0x58300004, 0xcf401080, 0x6ffc2000,
    0x58300004, 0xcfc00110, 0x80000168, 0x6c708000, 0x6c544000, 0x43158000, 0x5b304a00, 0xc2800002,
    0x58300004, 0xce800008, 0x6c508000, 0xc0004880, 0x40100000, 0x5800000e, 0xc9000000, 0x00000000,
    0x00000000, 0x59100002, 0xcd000000, 0xc0004816, 0xc8000000, 0x00000000, 0x00000000, 0x5c000000,
    0x84000072, 0xc11c0000, 0xc000082c, 0xcd040e08, 0xc0004816, 0xc8000000, 0x00000000, 0x00000000,
    0x5c000000, 0x84000012, 0x00000000, 0x00000000, 0x00000000, 0x8000ffa0, 0xc11c0002, 0xc000082c,
    0xcd040e08, 0x00000000, 0x00000000, 0x00000000, 0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000,
    0x80000a80, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xa8e2ffc8, 0x00000000, 0xc1220002,
    0xd90c0000, 0xc0004964, 0xca000000, 0x6c7c8000, 0x6c544000, 0x43d5e000, 0x5bfc4a00, 0xdfe40000,
    0x5e200002, 0x840006a0, 0x00000000, 0x583c0004, 0xc2800000, 0xca820080, 0xc0004930, 0xcac00000,
    0x00000000, 0x00000000, 0x6eece000, 0x6eefc010, 0x46e8a000, 0xc1000000, 0xdd500041, 0x6d106010,
    0x4514a000, 0xc1000000, 0xdd514209, 0x4514c000, 0xa9500181, 0xc00049a6, 0xca000000, 0xa94a0003,
    0x00000000, 0x6e660000, 0x6e660010, 0x46252000, 0x8400014a, 0x00000000, 0xc0004812, 0xc8000000,
    0x00000000, 0x00000000, 0x5c000000, 0x84000072, 0xc11c0000, 0xc000082c, 0xcd040e08, 0xc0004812,
    0xc8000000, 0x00000000, 0x00000000, 0x5c000000, 0x84000012, 0x00000000, 0x00000000, 0x00000000,
    0x8000ffa0, 0xc11c0002, 0xc000082c, 0xcd040e08, 0x6c508000, 0xc0004880, 0x40100000, 0x58000004,
    0xc9000000, 0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0x6c508000, 0xc0004880, 0x40100000,
    0x58000006, 0xc9000000, 0x00000000, 0x00000000, 0x41148000, 0xcd000000, 0x800007d0, 0x00000000,
    0xa95203a1, 0xc0001004, 0xcb800000, 0xc3400000, 0xdd740041, 0x5f740000, 0x840000b8, 0xc1218e08,
    0x5911baf6, 0x47908000, 0x8400035a, 0x00000000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000008,
    0xc9000000, 0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0x6c508000, 0xc0004880, 0x40100000,
    0x5800000a, 0xc9000000, 0x00000000, 0x00000000, 0x41148000, 0xcd000000, 0x800006d0, 0x00000000,
    0xc000496c, 0xcb000000, 0x583c0026, 0xcac00000, 0xc0004878, 0xc8040000, 0x6c908000, 0x41088000,
    0x40100000, 0x58000002, 0xca800000, 0x00000000, 0x00000000, 0x6ea90000, 0x5d300008, 0x88000032,
    0x59300002, 0xc3000000, 0xc5300010, 0x6d104010, 0x40100000, 0xca800000, 0x5c000002, 0xcac00000,
    0x5d300000, 0x84000022, 0x6f246000, 0x6ae56000, 0xc1000040, 0x46512000, 0x6aa54010, 0x42e96000,
    0x583c0026, 0xcec00000, 0xc1218e08, 0x5911baf6, 0xc0001004, 0xcd000000, 0x593c0026, 0xc000100e,
    0xcd000068, 0xc1340000, 0xc0001010, 0xcd001a08, 0xc1200008, 0xa94a0003, 0xc0001012, 0xc1200004,
    0x59100004, 0xcd0000c0, 0xc1360002, 0xcd001b08, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0xa8e2ffc8, 0x00000000, 0xc1220002, 0xd90c0000, 0xc0001004, 0xc9000000, 0x00000000,
    0x00000000, 0x47908000, 0x8400009a, 0x00000000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000008,
    0xc9000000, 0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0x6c508000, 0xc0004880, 0x40100000,
    0x5800000a, 0xc9000000, 0x00000000, 0x00000000, 0x41148000, 0xcd000000, 0x80000410, 0x00000000,
    0x6c508000, 0xc0004880, 0x40100000, 0x58000000, 0xc9000000, 0x00000000, 0x00000000, 0x59100002,
    0xcd000000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000002, 0xc9000000, 0x00000000, 0x00000000,
    0x41148000, 0xcd000000, 0xc0004930, 0xcd800080, 0xc3000000, 0x583c0008, 0xcf000000, 0x800000e8,
    0xc0001004, 0xca000000, 0x583c0006, 0xce400000, 0x583c0024, 0xce000000, 0xc0004814, 0xc8000000,
    0x00000000, 0x00000000, 0x5c000000, 0x8400008a, 0xc001fffe, 0x46400000, 0x84000070, 0xc11c0000,
    0xc000082c, 0xcd040e08, 0xc0004814, 0xc8000000, 0x00000000, 0x00000000, 0x5c000000, 0x84000012,
    0x00000000, 0x00000000, 0x00000000, 0x8000ffa0, 0xc11c0002, 0xc000082c, 0xcd040e08, 0xc0004862,
    0xc2000000, 0xca000080, 0xc000493a, 0xca400000, 0x00000000, 0x00000000, 0x42254000, 0x5ee80200,
    0x8800fffa, 0xc6e80000, 0xc0004000, 0x58001600, 0x40280000, 0xcb800000, 0x00000000, 0x583c0022,
    0xcf800000, 0xc0004862, 0xce800080, 0xc0001406, 0xcac00000, 0xc2800002, 0x00000000, 0xc66c1050,
    0xc6ac0a08, 0xcec00000, 0xc2000000, 0xdf600040, 0x5e600080, 0x8400ffd2, 0xc000491c, 0xca400000,
    0xc000491e, 0xca800000, 0x99006840, 0xda580000, 0xda980001, 0x00000000, 0xc0004964, 0xcbc00000,
    0x00000000, 0x00000000, 0x5ffc0000, 0x840000ea, 0xc2000000, 0xdf610050, 0x5e6001fe, 0x8800ffd0,
    0xc000491a, 0xc9800000, 0xc0004862, 0xc9400000, 0x6d9c6000, 0x459ce000, 0x59dc4c80, 0x990066a0,
    0xd9580000, 0xd9980001, 0xd9d40000, 0x99006618, 0xc000491c, 0xc1400000, 0xc9420050, 0xc2000000,
    0xdf600040, 0x5e600080, 0x8400ffd2, 0xc000491c, 0xca400000, 0xc000491e, 0xca800000, 0x99006840,
    0xda580000, 0xda980001, 0x00000000, 0xc0004970, 0xcb400000, 0x00000000, 0x00000000, 0x5e740082,
    0x8400e498, 0x00000000, 0x8000bc70, 0x00000000, 0x6c508000, 0xc0004880, 0x40100000, 0x58000016,
    0xc9000000, 0x00000000, 0x00000000, 0x59100002, 0xcd000000, 0x8000e0c8, 0x6c6c8000, 0x6c544000,
    0x42d56000, 0x5aec4a00, 0xc000487c, 0xc8040000, 0x00000000, 0x00000000, 0x40080000, 0xca000000,
    0xc4240000, 0x00000000, 0xa6060108, 0xc3c00000, 0xc2000000, 0x582c000c, 0xca010040, 0x00000000,
    0x00000000, 0x5a200002, 0xc6100840, 0xcd000840, 0x5e60000e, 0x8400bb58, 0xc2200000, 0x582c0002,
    0xce001010, 0x582c000c, 0xcfc00840, 0x582c0020, 0xcfc01080, 0x582c0010, 0xc1400000, 0xcd400001,
    0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400001, 0xcd400020,
    0xc000481a, 0xca000000, 0x00000000, 0x00000000, 0x5a200002, 0xce000000, 0x8000ba90, 0xc2200004,
    0x582c0002, 0xce001010, 0x582c000c, 0xcfc00840, 0x99006f68, 0x582c0002, 0xc9400000, 0xc1a20000,
    0x8000ba40, 0xc3e1fffe, 0x597dfffe, 0x593dfef4, 0x94000001, 0x00000000, 0x00000000, 0x00000000,
    0xc0800000, 0xdf4b0040, 0xc0004900, 0xcb800000, 0xc2000000, 0xc000490a, 0xa78000b0, 0xcbc00000,
    0xc1000000, 0xd9000001, 0xc1000002, 0xd90c0000, 0x6ff46000, 0x47f5a000, 0x5b744c80, 0xc2400000,
    0x58340004, 0xca400080, 0xc0004900, 0xce000008, 0x5a640002, 0x58340004, 0xc6500080, 0xcd000080,
    0xc0004914, 0xca400000, 0xc2000002, 0x6a3d0000, 0x72252000, 0xce400000, 0xc0000408, 0xce000000,
    0xa78200a8, 0xc0004908, 0xcbc00000, 0xc1000000, 0xd9000001, 0xc1000002, 0xd90c0000, 0x6ff4a000,
    0x47f5a000, 0x5b744e20, 0xc2800000, 0x58340006, 0xca800080, 0xc2000000, 0xc0004900, 0xce000108,
    0x5ea80002, 0x58340006, 0xc6900080, 0xcd000080, 0x5a7c0020, 0xc2000002, 0x6a250000, 0xc0000408,
    0xce000000, 0xdca80001, 0x5ea80000, 0x8400a7f8, 0x00000000, 0xa4800210, 0x00000000, 0xc3c00000,
    0xc000140e, 0xcbc00020, 0xc3400000, 0xc2400000, 0x6ff86000, 0x47f9c000, 0x5bb84c80, 0x58380008,
    0xcb400080, 0x58380006, 0xca400080, 0x5f740002, 0x58380008, 0xc7500080, 0xcd000080, 0xc2000000,
    0x58380004, 0xca020080, 0xc3000000, 0x5838000c, 0xcb000028, 0x5a640002, 0x46250000, 0x8400fff8,
    0xc2400000, 0x58380006, 0xc6500080, 0xcd000080, 0xc2000000, 0x5838000a, 0xca020080, 0x5b300002,
    0x5838000c, 0xc7100028, 0xcd000028, 0xc2420020, 0x5a200004, 0x46612000, 0x8400fff8, 0xc2000000,
    0x5838000a, 0xc6101080, 0xcd001080, 0xc000498c, 0xca400000, 0xc2000002, 0x6a3d0000, 0x72252000,
    0xce400000, 0x5f740000, 0x84000028, 0xc0004912, 0xca000000, 0xc2c00002, 0x6afd6000, 0x7ec16000,
    0x76e10000, 0xce000000, 0x5f300020, 0x84000028, 0xc0004924, 0xca000000, 0xc2c00002, 0x6afd6000,
    0x7ec16000, 0x76e10000, 0xce000000, 0xa4820050, 0xc2400000, 0xc000140e, 0xca408020, 0xc2000002,
    0xc0004900, 0xce000008, 0xc000490a, 0xce400000, 0xc1000000, 0xd9000001, 0xd8400080, 0xc1000004,
    0xd9000001, 0xa48402b8, 0x00000000, 0xc3c00000, 0xc000140e, 0xcbc10020, 0xc2800000, 0xc2000000,
    0x6ff8a000, 0x47f9c000, 0x5bb84e20, 0x58380036, 0xca800080, 0x58380006, 0xca020080, 0xc3400000,
    0x58380036, 0xcb420080, 0x5aa80002, 0x46290000, 0x8400fff8, 0xc2800000, 0x58380036, 0xc6900080,
    0xcd000080, 0x5f740002, 0x58380036, 0xc7501080, 0xcd001080, 0xc000498e, 0xca400000, 0xc2000002,
    0x6a3d0000, 0x72252000, 0xce400000, 0xc000492a, 0xca800000, 0x5e740000, 0x84000028, 0xc0004910,
    0xca000000, 0xc2c00002, 0x6afd6000, 0x7ec16000, 0x76e10000, 0xce000000, 0x6abd4010, 0xa6800112,
    0x00000000, 0x5838003a, 0xca000000, 0x58000002, 0xca400000, 0x5838000e, 0x00000000, 0xce000001,
    0xce400000, 0xc2400000, 0xdd250040, 0xc1000080, 0x46508000, 0xc2400000, 0xc6240080, 0x45250000,
    0x00000000, 0xc5240004, 0x5d240078, 0xc1000078, 0xc5240004, 0xc6600080, 0x5c000002, 0xce000080,
    0xc000492a, 0xca000000, 0xc2c00002, 0x6afd6000, 0x72e10000, 0xce000000, 0xc000492c, 0xca000000,
    0xc2c00002, 0x6afd6000, 0x72e10000, 0xce000000, 0x80000028, 0xc000492c, 0xca000000, 0xc2c00002,
    0x6afd6000, 0x7ec16000, 0x76e10000, 0xce000000, 0xa4880068, 0xc2c00000, 0xc000140e, 0xcac20020,
    0xc000490e, 0xca400000, 0xc2000002, 0x6a2d0000, 0x7e010000, 0x76252000, 0xce400000, 0xc0004990,
    0xca400000, 0xc2000002, 0x6a2d0000, 0x72252000, 0xce400000, 0xa4860050, 0xc2400000, 0xc000140e,
    0xca418020, 0xc2020002, 0xc0004900, 0xce000108, 0xc0004908, 0xce400000, 0xc1000000, 0xd9000001,
    0xd8400080, 0xc1000004, 0xd9000001, 0xc0001408, 0xcc800000, 0xc10e0002, 0xd90c0000, 0x8000f738,
    0xdfbc0001, 0xc0004992, 0x99006fa8, 0xc9400000, 0xc7d80000, 0x00000000, 0xc5700000, 0x5ef00020,
    0x88000140, 0x6f346000, 0x4735a000, 0x5b744c80, 0x58340008, 0xc2400000, 0xca400080, 0x00000000,
    0xc2000000, 0x5a640002, 0xc6500080, 0xcd000080, 0x58340004, 0xca000080, 0x00000000, 0x00000000,
    0x5e200002, 0xc6100080, 0xcd000080, 0xc0004912, 0xca800000, 0xc2400002, 0x6a712000, 0x72694000,
    0xce800000, 0x5e200000, 0x8400003a, 0xc000480a, 0xca000000, 0xc0000408, 0xca800000, 0x76610000,
    0x00000000, 0x72294000, 0xce800000, 0x80000020, 0xc0004914, 0xca000000, 0x7e412000, 0x00000000,
    0x76610000, 0xce000000, 0x800000b0, 0x6ef4a000, 0x46f5a000, 0x5b744e20, 0x58340036, 0xc2400000,
    0xca420080, 0x00000000, 0xc2000000, 0x5a640002, 0xc6501080, 0xcd001080, 0x58340006, 0xca000080,
    0x00000000, 0x00000000, 0x5a200002, 0xc6100080, 0xcd000080, 0xc0004910, 0xca400000, 0xc2000002,
    0x6a2d0000, 0x72252000, 0xce400000, 0xc2000002, 0x6a310000, 0xc000042a, 0xce000000, 0xc1040002,
    0xd90c0000, 0x00000000, 0x8000f4a0, 0x00000000, 0xc4980930, 0x9d000000, 0xc5580030, 0xc0000838,
    0xcd840000, 0xc1440200, 0xc1c01600, 0xc55c1078, 0xc000100e, 0x9d000000, 0xcd800000, 0xc000100c,
    0xcdc00000, 0xc0004862, 0xc9c00000, 0x00000000, 0x00000000, 0xd9d80001, 0xc0005600, 0x401c0000,
    0x5dc05800, 0x8800fffa, 0x5c000200, 0xcd800000, 0xc1f0000a, 0x71d4a000, 0xdd980000, 0xdd9c0001,
    0x41d8e000, 0xc5d40268, 0xc0001010, 0xcd400000, 0x6c9c8000, 0x449ce000, 0x449ce000, 0x59dc0004,
    0xc1601260, 0xc5d40268, 0x9d000000, 0xc0001012, 0xcd400000, 0x00000000, 0x00000000, 0xd9580000,
    0x6d586000, 0x4558c000, 0x59984c80, 0xd9980001, 0x5818000a, 0xc1800000, 0xc9800080, 0xc0005400,
    0x6d5ca000, 0x401c0000, 0x40180000, 0xc9400000, 0x58000002, 0x00000000, 0xc9c00000, 0xc0004930,
    0xcd400000, 0xc0004932, 0xcdc00000, 0x59980004, 0xc1c20020, 0xb59cfff8, 0x00000000, 0xc1800000,
    0xdd9c0001, 0x581c000a, 0xcd800080, 0x581c000c, 0xc1800000, 0xc9800028, 0xc1c00002, 0xdd940000,
    0x69d4e000, 0x5d980002, 0xcd800028, 0xc0004924, 0xc9800000, 0x00000000, 0x9d000000, 0x00000000,
    0x71d8c000, 0xcd800000, 0xc000492a, 0xc9400000, 0xc1c00002, 0x69d8e000, 0x7dc0c000, 0x7594a000,
    0xcd400000, 0xc000492c, 0xc9400000, 0xdd800001, 0x5800003a, 0x75d4a000, 0x840000f0, 0xc9400001,
    0xc9800000, 0xdd800001, 0x5800000e, 0x00000000, 0xcd400001, 0xcd800000, 0xc1800000, 0xdd190040,
    0xc1000080, 0x45908000, 0xc1800000, 0xc5580080, 0x4518a000, 0x00000000, 0xc5180004, 0x5d180078,
    0xc1000078, 0xc5180004, 0xc5940080, 0x5c000002, 0xcd400080, 0xc000492c, 0xc9400000, 0xc000492a,
    0xc9800000, 0x71d4a000, 0xc000492c, 0xcd400000, 0x71d8c000, 0xc000492a, 0xcd800000, 0x9cc00000,
    0x00000000, 0x00000000, 0x00000000, 0xc0004862, 0xc9800000, 0x00000000, 0xc1c00200, 0x4194c000,
    0x45d8e000, 0x8800fffa, 0xc5d80000, 0xc0004862, 0xcd800000, 0xc0001406, 0xc9800000, 0xc1c00002,
    0x9d000000, 0xc5d80a08, 0xc5581050, 0xcd800000, 0xc0004930, 0xc9800000, 0xc0004932, 0xc9c00000,
    0xc140000e, 0xc5581c20, 0xdd940000, 0xc0005600, 0x40140000, 0x5d405800, 0x8800fffa, 0x5c000200,
    0xcd800000, 0x58000002, 0x5d405800, 0x8800fffa, 0x5c000200, 0xcdc00000, 0xdd540000, 0xc1c00000,
    0x58140006, 0xc9c20080, 0xc1800000, 0x58140000, 0xc98000e0, 0x6ddc2000, 0xc000491e, 0x41d8e000,
    0xcdc00000, 0xdd980000, 0xc1c00022, 0xc5d80d78, 0xdd940001, 0xc5581c20, 0xc000491c, 0xcd800000,
    0xdd540000, 0xc1c00000, 0x58140006, 0xc9c20080, 0xc1800000, 0x58140004, 0xc9820080, 0x00000000,
    0x59dc0002, 0x459cc000, 0x8400fff8, 0xc1c00000, 0x9d000000, 0x58140006, 0xc5d81080, 0xcd801080,
    0xc0004860, 0xc9400000, 0xc1820080, 0xc1d00002, 0x58146b00, 0xd5800000, 0x58000002, 0xd5800001,
    0x59540004, 0xb558fff8, 0xc0004860, 0xc1400000, 0xcd400000, 0xdd980001, 0x9d000000, 0xdd940000,
    0xc0001404, 0xcdc00808, 0xc1c00000, 0xc1800200, 0x5d980004, 0xdf5d0050, 0x45d8a000, 0x8800ffda,
    0xdd800001, 0x5800000e, 0x00000000, 0xc9400001, 0xc9800000, 0xc1c00002, 0xc5d43f08, 0xc5d81e08,
    0xc0004862, 0xc9c00000, 0x00000000, 0x00000000, 0x581c5600, 0x5dc05800, 0x8800fffa, 0x5c000200,
    0xcd400000, 0x58000002, 0x5dc05800, 0x8800fffa, 0x5c000200, 0xcd800000, 0xc0004862, 0xc9c00000,
    0x00000000, 0xc15004c0, 0xc5d40068, 0xdd9c0000, 0xc5d41c20, 0xc1c00000, 0xdd800001, 0x58000038,
    0xc9c00080, 0xdd800001, 0xc1800000, 0x58000002, 0xc98000e0, 0x6ddc2000, 0xc000491c, 0x41d8e000,
    0xcd400001, 0xcdc00000, 0xdd940001, 0xc1c00000, 0x58140038, 0xc9c00080, 0xc1800000, 0x58140006,
    0xc9820080, 0x00000000, 0x59dc0002, 0x459cc000, 0x8400fff8, 0xc1c00000, 0x9d000000, 0x58140038,
    0xc5d80080, 0xcd800080, 0xc1c00000, 0xdf5c0040, 0x5ddc0080, 0x8400ffd2, 0x00000000, 0x9d000000,
    0x00000000, 0x00000000, 0x00000000, 0xc160fffe, 0xc0000a10, 0xc9440068, 0xc1a0fffe, 0x59980e28,
    0xc000100c, 0xcd400000, 0xc000100e, 0xcd800000, 0xc0004962, 0xc9800000, 0x00000000, 0xc170000a,
    0x7194a000, 0x6c988000, 0x4498c000, 0x4498c000, 0x59980004, 0xc5940278, 0xc0001010, 0xcd400000,
    0xc0004946, 0xc9400000, 0x00000000, 0x00000000, 0x6d58a000, 0x6d5c4000, 0x45d8c000, 0x4558c000,
    0xc000494a, 0xc9400000, 0xc0004948, 0xc9c00000, 0x4194c000, 0xc1400012, 0xc55c1820, 0x9d000000,
    0xc59c0270, 0xc0001012, 0xcdc00000, 0xc1400000, 0x58000014, 0xc9410040, 0xc0004950, 0xc9c00000,
    0xc5580000, 0xc5940840, 0xc5581080, 0xd9940000, 0xc000493c, 0xc9400000, 0xc0004954, 0xc9800000,
    0x59dc00a8, 0x455ce000, 0x41d8e000, 0x5d5c0030, 0x8800fff8, 0xc1c00030, 0xc1800000, 0xc5d84030,
    0xc1400000, 0xc5d40010, 0x5dd40002, 0x8400005a, 0x5dd40004, 0x84000082, 0x5dd40006, 0x840000aa,
    0x5dd80026, 0x840000d2, 0xdd540000, 0xdd800001, 0x58000008, 0x40180000, 0xcd400000, 0x59980002,
    0x8000ffa8, 0xdd540000, 0xdd800001, 0x58000008, 0x40180000, 0xcd4000c0, 0x59980002, 0x8000ff70,
    0xdd540000, 0xdd800001, 0x58000008, 0x40180000, 0xcd400080, 0x59980002, 0x8000ff38, 0xdd540000,
    0xdd800001, 0x58000008, 0x40180000, 0xcd400040, 0x59980002, 0x8000ff00, 0x00000000, 0x9d000000,
    0x00000000, 0x00000000, 0x00000000, 0x58000014, 0xc9400000, 0xc0004954, 0xc9c00000, 0xc0004950,
    0xc9400080, 0xdd800001, 0x5800002a, 0x5d9c0000, 0x8400003a, 0x5d9c0002, 0x8400003a, 0x5d9c0004,
    0x84000052, 0xc55b0040, 0xc55c08c0, 0xcd800041, 0xcdc008c0, 0x80000048, 0xcd400000, 0x80000038,
    0xc55900c0, 0xc55c1840, 0xcd8000c1, 0xcdc01840, 0x80000010, 0xc55a0080, 0xc55c1080, 0xcd800081,
    0xcdc01080, 0x9d000000, 0x00000000, 0x00000000, 0x00000000, 0xc1e00000, 0xa540fffa, 0xc0000a14,
    0xc1a20002, 0x9d000000, 0xcd841108, 0xc0000a1c, 0xcdc41040, 0x59540002, 0x6994e018, 0x61c0c008,
    0x4194a000, 0x5d940040, 0x8800fffa, 0xc5940000, 0x9d000000, 0xcd400000, 0x00000000, 0x00000000,
};

static unsigned int firmware_binary_data[] = {
};


#endif  //  IFXMIPS_PTM_FW_DANUBE_H
